#include "PointLight.h"



PointLight::PointLight(int id, std::vector<GLfloat> pos) : Light(id, pos)
{
	_Position[3] = 1.0f;	//We set the 4th position value to 1 to indicate this is a point light
}


PointLight::~PointLight()
{
}

void PointLight::Render()
{
	//Render Ambient, Diffuse, Position and Attenuation values
	glLightfv(_ID, GL_AMBIENT, &Ambient[0]);
	glLightfv(_ID, GL_DIFFUSE, &Diffuse[0]);
	glLightfv(_ID, GL_POSITION, &_Position[0]);
	glLightf(_ID, GL_CONSTANT_ATTENUATION, _ConstAtten);
	glLightf(_ID, GL_LINEAR_ATTENUATION, _LinearAtten);
	glLightf(_ID, GL_QUADRATIC_ATTENUATION, _QuadraticAtten);
}